/* vim: set sw=8 ts=8 si : */
/*********************************************
* Author: Guido Socher, Copyright: GPL 
* Copyright: GPL
**********************************************/
#include <avr/signal.h>
#include <avr/interrupt.h>
#include <avr/io.h>
#include "avr_compat.h"


volatile static unsigned char analog_busy; 
volatile static int analog_result; 

/* the following function will be called when analog conversion is done */
SIGNAL(SIG_ADC) {
	unsigned char adlow,adhigh;
	adlow=inp(ADCL); /* read low first !! */
	adhigh=inp(ADCH); /* read low first !! */
	analog_result=(adhigh<<8)|(adlow & 0xFF);
	analog_busy=0;
}

/* return analog value of a given channel. You must enable interrupt with
* sei() in the main program */
int convertanalog(unsigned char channel,unsigned char iref) 
{
	analog_busy=1;
        /* enable analog to digital conversion in single run mode
        *  without noise canceler function. See datasheet of atmega8 page 195
        * We set ADPS2=1 and ADPS0,ADPS1=0 to have a clock division factor of 32.
        * This is needed to stay in the recommended range of 50-200kHz 
        * ADEN: Analog Digital Converter Enable
        * ADIE: ADC Interrupt Enable
        * ADIF: ADC Interrupt Flag
        * ADCSR: ADC Control and Status Register
        * ADPS2..ADPS0: ADC Prescaler Select Bits
	* REFS: Reference Selection Bits (page 203)
        */

	// int-ref with external capacitor at AREF pin: 
	// 2.56V int ref=REFS1=1,REFS0=1
	// write only the lower 3 bit for channel selection
	if (iref){
		// 2.56V ref
		outp((1<<REFS1)|(1<<REFS0)|(channel & 0x07),ADMUX); 
	}else{
		// 5V ref
		outp((1<<REFS0)|(channel & 0x07),ADMUX); 
	}
        outp((1<<ADEN)|(1<<ADIE)|(1<<ADIF)|(1<<ADPS2),ADCSR);

	/*  start conversion */
	sbi(ADCSR,ADSC);
	while(analog_busy); /* wait for result */
	return(analog_result);
}


